
unit MultiAlgorithms;

interface


uses Windows, math, Contnrs, Classes, Common,
     strUtils, //fr PosEx;
     dialogs, sysutils, graphics, GraphUtils;

type


  MultiSearchAlgorithms = (
      // mehrfache einfache Suche
      multinaiv,

      // Prfix-Suche:
       trienaiv, AC, AdvancedAC, MultiSA,

      // Suffix-Suche
      CW, SetHorspool, WuManber,

      // Faktor-Suche
      SBOM
  );


const MultiAlgorithmNames  : Array[MultiSearchAlgorithms] of String
      = (
          // Mehrfache einfache Suche
            'Naiver Algorithmus',

          // Prfix-Suche
            'Naive Trie-Suche', 'Aho-Corasick', 'Advanced AC', 'Multiple Shift-And',

          // Suffix-Suche
          'Commentz-Walter', 'Set Horspool', 'Wu-Manber',

          // Faktor-Suche
          'SBOM'
         );

      MultiColors: Array[MultiSearchAlgorithms] of TColor
       = (
          clWhite,
          // Prfix-Suche (4)
          clGray, clred, clMaroon, clPurple,

          // Suffix-Suche
          clgreen, clSkyBlue, clBlue,

          // Faktor-Suche
          $000080FF {Orange}
       );

type

  TMultiAlgTimeArray = Array[MultiSearchAlgorithms] of Int64;
  TMultiAlgTrefferArray = Array[MultiSearchAlgorithms] of TMultiTrefferList;
  TMultiTimesArray = Array of TMultiAlgTimeArray;

    TMultiStatistics = Array of Array of TMultiAlgTimeArray;




  // Fr den komplett naiven Ansatz: Suche mit Horspool.
  // Dafr aber kleiner Umbau auf die hier ntigen Results
  // PreProcessing fr Horspool (leicht anders als BC_BM)
  function PreProcess_SimpleBC(p: String): TBC_IntArray;
  // Suche mit Horspool
  function Search_Simple(t,p: String; idx: Integer; Trefferlist: TMultiTrefferList): Boolean;

  function Search_Naiv(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;

  function TrieSearch(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;

  function AhoCorasick(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;

  function AdvancedAhoCorasick(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;

  function PreProcess_MultipleSA(P: TStrings): TBC_CardinalArray;
  function Search_MultipleSA(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;

  function PreProcess_CW_BC(p: TStrings; def: Integer): TBC_IntArray;
  function CommentzWalter(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;

  function PreProcess_SetHorspool(p: TStrings; def: Integer): TBC_IntArray;
  function Search_SetHorspool(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;

  function Search_WuManber(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;

  function Search_SBOM(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;


  function MultiSearch(t: String; P: TStrings; alg: MultiSearchAlgorithms; TrefferList: TMultiTrefferList): boolean;


implementation


function PreProcess_SimpleBC(p: String): TBC_IntArray;
var i, m: Integer;
    c: Char;
begin
  m := Length(p);
  for c := low(Char) to High(Char) do
    result[c] := m;
  for i := 1 to m-1 do     // !! m-1 !!
    result[p[i]] := m-i;
end;

// Suche mit Horspool
function Search_Simple(t,p: String; idx: Integer; Trefferlist: TObjectlist): Boolean;
var m, n, k, j: Integer;
    BC: TBC_IntArray;
    BC_last: Integer;
    Large: Integer;
begin
  result := True;
  m := Length(p);
  n := Length(t);
  Large := m + n + 1;

  BC := PreProcess_SimpleBC(p);

  // "echten" BC-Shift merken
  BC_last := BC[p[m]];
  // BC(lastCh) mit "Large" berschreiben
  BC[p[m]] := Large;

  k := m;

  while k <= n do
  begin
      //fast loop
      repeat
        k := k + BC[t[k]];
      until k > n;

      //undo
      if k <= Large then
        //Muster nicht gefunden
        break
      else
        k := k - Large;

      j := 1;
      // slow loop
      while (j < m) and (p[m-j] = t[k-j]) do
        inc(j);

      if j=m then
      begin
        // Muster gefunden
        if assigned(Trefferlist) then
            Trefferlist.Add(tTreffer.Create(idx,k-j+1));
        k := k + 1; // nur um eins verschieben. ich suche JEDES Vorkommen
      end else
      begin
          // Muster verschieben
          if t[k] = p[m] then
            k := k + BC_last
          else
            k := k + BC[t[k]];
      end;
  end;
end;

function Search_Naiv(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;
var i: Integer;
begin
  result := true;
  for i := 0 to P.Count - 1 do
  begin
    Search_Simple(t,p[i],i,Trefferlist);
  end;
end;


// -------------------------------
// -------------------------------

function TrieSearch(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;
var Trie: TTrie;
    k, j, n, aus: Integer;
    u: TNode;
begin
  result := true;
  Trie := TTrie.Create;
  Trie.Build(P);

  n := length(t);

  for k := 1 to n do
  begin
      u := Trie.Root;
      j := 0;
      while (k + j <= n) and (u.GetTarget(t[k+j]) <> NIL) do
      begin
          u := u.GetTarget(t[k+j]);
          inc(j);
          if u.Terminal then
              // Treffer
              if assigned(Trefferlist) then
                for aus := 0 to u.OutputList.Count - 1 do
                  Trefferlist.Add(TTreffer.Create(Integer(u.OutputList[aus]), k));
      end;
  end;
  Trie.Free;
end;

function AhoCorasick(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;
var AhoTrie: TAhoTrie;
    k, j, n, aus: Integer;
    u: TNode;
begin
  result := True;
  AhoTrie := TAhoTrie.Create;
  AhoTrie.BuildAho(P);
  n := length(t);
  u := AhoTrie.Root;
  for k := 1 to n do
  begin
      While u.GetTarget(t[k]) = Nil do u := u.SuffixLink;
      u := u.GetTarget(t[k]);
      if u.Terminal then
      begin
        if assigned(Trefferlist) then
          for aus := 0 to u.OutputList.Count - 1 do
          begin
              j := Integer(u.OutputList[aus]);
              Trefferlist.Add(TTreffer.Create(j, k-length(p[j])+1 ));
          end;
      end;
  end;
  AhoTrie.Free;
end;

function AdvancedAhoCorasick(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;
var AhoTrie: TAhoTrie;
    k, n, j, aus: Integer;
    u: TNode;
begin
  result := True;
  AhoTrie := TAhoTrie.Create;
  AhoTrie.BuildAdvancedAho(P);
  n := length(t);
  u := AhoTrie.Root;
  for k := 1 to n do
  begin
      u := u.GetTarget(t[k]);
      if u.Terminal then
      begin
          if assigned(Trefferlist) then
              for aus := 0 to u.OutputList.Count - 1 do
              begin
                  j := Integer(u.OutputList[aus]);
                  Trefferlist.Add(TTreffer.Create(j, k-length(p[j])+1 ));
              end;
      end;
  end;
  AhoTrie.Free;
end;

function PreProcess_MultipleSA(P: TStrings): TBC_CardinalArray;
var i,m, r: Integer;
  j: cardinal;
begin
  //for i := 0 to 255 do
  //  result[i] := 0;
  ZeroMemory(@result[Chr(0)],length(result)*SizeOf(Cardinal));
  j := 1;
  for r := 0 to P.Count - 1 do
  begin
      m := Length(p[r]);
      for i := 1 to m do
      begin
        result[p[r][i]] := result[p[r][i]] or j;
        j := j shl 1;
      end;
  end;
end;

function Search_MultipleSA(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;
var DI, DF, D, C: Cardinal;
    i, r, k, ges, n: integer;
    B: TBC_CardinalArray;
begin
  ges := 0;
  for i := 0 to P.Count - 1 do
    ges := ges + length(p[i]);

  if ges > 32 then
      result := false   // Suche nicht durchfhren
  else
  begin
      // Suche durchfhren
      result := true;
      B := PreProcess_MultipleSA(P);
      // DI und DF aufbauen
      DI := 0;
      DF := 0;
      for i := P.Count - 1 downto 0 do
      begin
        DI := (DI shl length(p[i])) or 1;
        DF := ((DF shl 1) or 1) shl (length(p[i])-1);
      end;
      // eigentliche Suche
      D := 0;
      n := length(t);
      for k := 1 to  n do
      begin
          D := ((D shl 1) or DI) and B[t[k]];
          if (D and DF) <> 0 then
          begin
              // evtl. ein oder mehrere Muster gefunden
              C := 1 shl (length(p[0])-1);
              for r := 0 to P.Count - 1 do
              begin
                  //C := (C shl length(p[r])) or (1 shl (length(p[r])-1));
                  if (D and C) <> 0 then
                  begin
                      //Muster r gefunden
                      if assigned(Trefferlist) then
                        Trefferlist.Add(TTreffer.Create(r, k-length(p[r])+1 ));
                  end;
                  if r < P.Count - 1 then
                    C := C shl length(P[r+1]);
                  //C := (C shl length(p[r+1])) or (1 shl (length(p[r+1])-1))
              end;
          end;
      end;
  end;
end;


function PreProcess_CW_BC(p: TStrings; def: Integer): TBC_IntArray;
var a: Char;
    r, i, mi: Integer;
begin
  // Array initialisieren
  for a := Low(Char) to High(Char) do
    result[a] := def;
  for r := 0 to p.Count - 1 do
  begin
      mi := length(p[r]);
      for i := 1 to mi do
        if result[p[r][i]] > mi-i then
          result[p[r][i]] := mi-i;
  end;
end;

function CommentzWalter(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;
var CommentzWalterTrie: TCommentzWalterTrie;
    BC: TBC_IntArray;
    n,k,j,aus,i: Integer;
    u: TNode;
    BCs: Integer;
begin
  result := True;
  CommentzWalterTrie := TCommentzWalterTrie.Create;
  CommentzWalterTrie.BuildCW(p);
  BC := PreProcess_CW_BC(P, CommentzWalterTrie.lmin);

  n := length(t);
  k := CommentzWalterTrie.lmin;
  while k <= n do
  begin
      u := CommentzWalterTrie.Root;
      j := 0;
      while u.GetTarget(t[k-j]) <> nil do
      begin
          u := u.GetTarget(t[k-j]);
          inc(j);
          if u.Terminal then
          begin
            // Treffer
            if assigned(Trefferlist) then
              for aus := 0 to u.OutputList.Count - 1 do
              begin
                i := Integer(u.OutputList[aus]);
                Trefferlist.Add(TTreffer.Create(Integer(u.OutputList[aus]), k - length(p[i])+1));
              end;
            end;
      end;
      // Target ist Nil, wir kommen nicht mehr weiter => Shift bestimmen
      BCs := max(1, BC[t[k-j]] - j);
      k := k + max(BCs, u.GS);
  end;
  CommentzWalterTrie.Free;
end;

function PreProcess_SetHorspool(p: TStrings; def: Integer): TBC_IntArray;
var a: Char;
    r, i, mi: Integer;
begin
  // Array initialisieren
  for a := Low(Char) to High(Char) do
    result[a] := def;
  for r := 0 to p.Count - 1 do
  begin
      mi := length(p[r]);
      for i := 1 to mi-1 do
        if result[p[r][i]] > mi-i then
          result[p[r][i]] := mi-i;
  end;
end;
function Search_SetHorspool(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;
var i, lmin, n, k, j, aus: Integer;
    Trie: TTrie;
    BC: TBC_IntArray;
    prev: TStrings;
    u: TNode;
begin
  result := True;
  prev := TStringlist.Create;
  prev.Capacity := P.Count;

  lmin := High(Integer);
  for i := 0 to P.Count - 1 do
  begin
    prev.Add(ReverseString(p[i]));
    if lmin > length(p[i]) then
      lmin := length(p[i]);
  end;
  BC := PreProcess_SetHorspool(P, lmin);
  Trie := TTrie.Create;
  Trie.Build(prev);

  n := length(t);
  k := lmin;

  while k <= n do
  begin
      u := Trie.Root;
      j := 0;
      while u.GetTarget(t[k-j]) <> nil do
      begin
          u := u.GetTarget(t[k-j]);
          inc(j);
          if u.Terminal then
          begin
            // Treffer
            if assigned(Trefferlist) then
              for aus := 0 to u.OutputList.Count - 1 do
              begin
                i := Integer(u.OutputList[aus]);
                Trefferlist.Add(TTreffer.Create(Integer(u.OutputList[aus]), k - length(p[i])+1));
              end;
            end;
      end;
      k := k + BC[t[k]];
  end;
  Trie.Free;
  prev.Free;
end;

function Search_WuManber(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;
const MAXHASH = $7FFF;  // Array-Gre: 2^15, 0 - 2^15-1
      MASK = $1F; // = binr 11111
var i, r, lmin, mi, B, def, k, n, j, h: Integer;
    Shift: Array[0..MAXHASH] of Integer; 
    Hash: Array[0..MAXHASH] of TList;
    Prefix: Array of Integer;
    TextPref: Integer;
begin
  result := true;
  // Preprocessing
  // Lnge des krzesten Musters und Gesamtlnge bestimmen
  lmin := High(Integer);
  for r := 0 to P.Count - 1 do
    if lmin > length(p[r]) then lmin := length(p[r]);

  // Gre der Blcke B bestimmen
  if lmin = 1 then
    B := 1
  else
    if (lmin > 2) and (lmin*P.Count > 400) then
      B := 3
    else
      B := 2;

  // Shift-Tabelle initialisieren
  def := lmin - B + 1;
  for i := 0 to MAXHASH do
    Shift[i] := def;

  // "Prfix-Hash" der Muster bestimmen
  Setlength(Prefix,P.Count);
  for r := 0 to P.Count - 1 do
  begin
    mi := length(p[r]);
    if B=1 then
      Prefix[r] := Integer(p[r][mi-lmin+1])
    else
      Prefix[r] := (Integer(p[r][mi-lmin+1]) shl 8) + Integer(p[r][mi-lmin+2]);
  end;

  // Shift- und Hash-Array ermitteln
  for r := 0 to P.Count - 1 do
  begin
    mi := length(p[r]);
    //for i := B to mi - 1 do
    for i := mi - lmin + B to mi - 1 do
    begin
      h := Integer(p[r][i]) AND MASK;
      if B >= 2 then h := (h shl 5) + (Integer(p[r][i-1]) and MASK);
      if B >= 3 then h := (h shl 5) + (Integer(p[r][i-2]) and MASK);
      if Shift[h] > mi-i then Shift[h] := mi-i;
    end;

    // Shift + Hash fr Suffix des Musters der Lnge B
    h := Integer(p[r][mi]) AND MASK;
    if B >= 2 then h := (h shl 5) + (Integer(p[r][mi-1]) and MASK);
    if B >= 3 then h := (h shl 5) + (Integer(p[r][mi-2]) and MASK);
    Shift[h] := 0;

    // Aktuelles Muster in die Liste an Hash[h] eintragen
    if not assigned(Hash[h]) then Hash[h] := TList.Create;
    Hash[h].Add(Pointer(r));
  end;

  // Suchphase
  k := lmin;
  n := length(t);
  while k <= n do
  begin
    // h fr aktuelles Suffix bestimmen
    h := Integer(t[k]) AND MASK;
    if B >= 2 then h := (h shl 5) + (Integer(t[k-1]) and MASK);
    if B >= 3 then h := (h shl 5) + (Integer(t[k-2]) and MASK);

    if shift[h]=0 then
    begin
      // mglicherweise ein Muster gefunden
      if B=1 then
        TextPref := Integer(t[k - lmin + 1])
      else
        TextPref := (Integer(t[k - lmin + 1]) shl 8) + Integer(t[k - lmin + 2]);

      if assigned(Hash[h]) then
      begin
        // (Das sollte aber immer so sein)
        // Muster in dieser Liste berprfen
        for r := 0 to Hash[h].Count - 1 do
        begin
          i := Integer(Hash[h].Items[r]);
          if Prefix[i] = TextPref then
          begin
              mi := length(p[i]);
              // "Prfix"-Hash stimmt auch berein
              if k >= mi then
              begin
                  // Muster ist auch lang genug - berprfen
                  j := 0;
                  while (j < mi) and (t[k-j] = p[i][mi-j]) do inc(j);

                  if j = mi then
                  begin
                      // Muster r tatschlich gefunden
                      if assigned(Trefferlist) then
                        Trefferlist.Add(TTreffer.Create(i, k - mi+1));
                  end;
              end;

          end;
        end;
      end;

      // berprfung auf Mustervorkommen komplett,
      // Verschiebung um 1
      k := k + 1;
    end else
      // shift[h]>0, verschieben
      k := k + shift[h];
  end;

  for i := 0 to MAXHASH do
    if assigned(Hash[i]) then hash[i].Free;
end;

function Search_SBOM(t: String; P: TStrings; Trefferlist: TMultiTrefferList): Boolean;
var PRevMin: tStrings;
    r,lmin, k, j, n, i, mi: Integer;
    MultiOracle: TMultiOracle;
    u: TNode;
begin
  result := True;

  // Minimale Musterlnge bestimmen
  lmin := High(Integer);
  for r := 0 to P.Count - 1 do
    if lmin > length(p[r]) then lmin := length(p[r]);

  // Strings bestimmen, fr die das Orakel aufgebaut werden muss
  PRevMin := tStringlist.Create;
  PRevMin.Capacity := P.Count;
  for r := 0 to P.Count -  1 do
    PRevMin.Add(ReverseString(LeftStr(P[r],lmin)));

  MultiOracle := TMultiOracle.Create;
  MultiOracle.BuildOracle(PRevMin);

  // Suchphase
  n := length(t);
  k := 0;
  while k <= n-lmin do
  begin
      u := MultiOracle.Root;
      j := lmin;
      while (j >= 1) and (u <> NIL) do
      begin
          u := u.GetTarget(t[k+j]);
          dec(j);
      end;

      if j = 0 then
      begin
          if (u <> NIL) then
          begin
            // mglicherweise ein (oder mehr) Muster gefunden
            // Problem: Faktor-Orakel erkennt auch Muster der Lnge lmin,
            // die kein Suffix unserer Muster P sind.
            if assigned(u.OutputList) then
            begin
              for r := 0 to u.OutputList.Count - 1 do
              begin
                mi := length(P[Integer(u.OutputList[r])]);
                i := 1;
                while (i <= mi) and (P[Integer(u.OutputList[r])][i] = t[k + i]) do
                  inc(i);

                if i = mi+1 then
                  //Muster gefunden
                  if assigned(Trefferlist) then
                            Trefferlist.Add(TTreffer.Create(Integer(u.OutputList[r]),
                            k +1));
              end
            end;

          end ;
          j := 1;
      end;
      k := k + j;
  end;

  MultiOracle.Free;
  PRevMin.Free;
end;

function MultiSearch(t: String; P: TStrings; alg: MultiSearchAlgorithms; TrefferList: TMultiTrefferList): boolean;
begin
  result := False;
  try
      case alg of
        multinaiv   : result := Search_Naiv(t, p,TrefferList);
        trienaiv    : result := TrieSearch(t, p, TrefferList);
        AC          : result := AhoCorasick(t, p, TrefferList);
        AdvancedAC  : result := AdvancedAhoCorasick(t, p, TrefferList);
        CW          : result := CommentzWalter(t, p, TrefferList);
        SetHorspool : result := Search_SetHorspool(t, p, TrefferList);
        WuManber    : result := Search_WuManber(t, p, TrefferList);
        SBOM        : result := Search_SBOM(t, p, TrefferList);
        MultiSA     : result := Search_MultipleSA(t, p, TrefferList);
      end;
  except
      on E: Exception do MessageDlg(E.Message, mtError, [mbok], 0 );
  end;
end;



end.
